/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PtSuperiorDto;
import jp.mosp.common.common.MospException;

public class PtSuperiorDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "UT_SUPERIOR";
	public static final String KEY_1 = "K_CODE";	//ЈR[h
	
	// 
	public static final String COL_K_CODE        = "K_CODE"       ;	// ЈR[h
	public static final String COL_SUPERIOR_CODE = "SUPERIOR_CODE";	// T|[^[ЈR[h
	
	public static final String ALS_SUPERIOR_NAME = "SUPERIOR_NAME";	// T|[^[Ј

	/**
	 * RXgN^
	 */
	public PtSuperiorDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PtSuperiorDto> mappingAll() throws SQLException {
		List<PtSuperiorDto> all = new ArrayList<PtSuperiorDto>();
		while (rs.next()) {
			PtSuperiorDto dto = mapping();
			dto.setStationCode (rs.getString(PmBasisDao.COL_STATION_CODE));
			dto.setKName       (rs.getString(PmBasisDao.COL_K_NAME      ));
			dto.setSuperiorName(rs.getString(ALS_SUPERIOR_NAME          ));
			all.add(dto);
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PtSuperiorDto UT_SUPERIORR[h
	 * @throws SQLException
	 */
	private PtSuperiorDto mapping() throws SQLException {
		PtSuperiorDto dto = new PtSuperiorDto();
		dto.setKCode       (rs.getString(COL_K_CODE       ));	// ЈR[h
		dto.setSuperiorCode(rs.getString(COL_SUPERIOR_CODE));	// T|[^[ЈR[h
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PtSuperiorDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtSuperiorDto findForKey(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			PtSuperiorDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return PtSuperiorDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtSuperiorDto findForUpdate(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			PtSuperiorDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public List<PtSuperiorDto> findForCondition(
			String stationCode ,
			String kCode       ,
			String kName       ,
			String superiorCode,
			String superiorName
	) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append("S." + COL_K_CODE + ", ");
		sb.append("S." + COL_SUPERIOR_CODE + ", ");
		sb.append("A." + PmBasisDao.COL_K_NAME + ", ");
		sb.append("A." + PmBasisDao.COL_STATION_CODE + ", ");
		sb.append("B." + PmBasisDao.COL_K_NAME + " AS " + ALS_SUPERIOR_NAME + ", ");
		sb.append("S." + INSERT_DATE + " AS " + INSERT_DATE + ", ");
		sb.append("S." + INSERT_USER + " AS " + INSERT_USER + ", ");
		sb.append("S." + UPDATE_DATE + " AS " + UPDATE_DATE + ", ");
		sb.append("S." + UPDATE_USER + " AS " + UPDATE_USER + " ");
		sb.append("FROM ");
		sb.append(TABLE + " S,");
		sb.append(PmBasisDao.TABLE + " A, ");
		sb.append(PmBasisDao.TABLE + " B ");
		sb.append("WHERE ");
		sb.append("S." + COL_K_CODE + " = A." + PmBasisDao.COL_K_CODE + " ");
		sb.append("AND ");
		sb.append("S." + COL_SUPERIOR_CODE + " = B." + PmBasisDao.COL_K_CODE + " ");
		sb.append("AND ");
		sb.append("S." + COL_K_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append("S." + COL_SUPERIOR_CODE + " LIKE ? ");
		sb.append("AND ");
		sb.append("A." + PmBasisDao.COL_STATION_CODE + " IN(");
		sb.append(PmStationDao.getStationQuery());
		sb.append(") AND ");
		sb.append("A." + PmBasisDao.COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append("B." + PmBasisDao.COL_K_NAME + " LIKE ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kCode + "%"             );
			setParam(index++, superiorCode + "%"      );
			setParam(index++, stationCode             );
			setParam(index++, "%" + kName + "%"       );
			setParam(index++, "%" + superiorName + "%");
			executeQuery();
			List<PtSuperiorDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PtSuperiorDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PtSuperiorDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PtSuperiorDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("OR ");
			sb.append(COL_SUPERIOR_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PtSuperiorDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode       ());	// ЈR[h
		setParam(index++, dto.getSuperiorCode());	// T|[^[ЈR[h
		setCommonParams(isInsert);
	}
	
	/**
	 * T|[^[ЈR[h擾SQL
	 * @return T|[^[ЈR[h擾SQL
	 */
	public static final String getSuperiorQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_SUPERIOR_CODE + " = ? ");
		return sb.toString();
	}

}
